create or replace package body tbicds.PCK_NOTE_PREFILL is
/* Copyright 2015 Intellica Corporation
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

  /*get outcomes reviewed*/
  function fnGetOutcomesReviewedList(pi_vPatientID        in varchar2,
                                     pi_nPatPWEventID     in number) return varchar2
  is

    v_nBreakMID       number := -1;
    v_nBreakIntakeID  number := -1;

    v_vName           varchar2(32767) := '';
    v_vCurrentScore   varchar2(32767) := '';
    v_vPreviousScore  varchar2(32767) := '';
    v_vStatus         varchar2(32767) := '';

    v_vResponse       varchar2(32767) := '';
    po_vResponseValue varchar2(32767) := '';

  begin

    --get all outcomes that are reviewed
    for rec in (
        select
       --t.patient_id,
       --t.pat_pw_id,
       --t.pat_pw_event_id,
       --t.pw_event_module_id,
         t.mid
        ,t.intake_id
        ,t2.acronym
        ,t2.module
        ,(select es.event_status
          from pat_pw_event_entry pe,
               stat_event_status es
          where pe.event_status_id = es.event_status_id
            and pe.patient_id = t.patient_id
            and pe.pw_event_module_id = t.pw_event_module_id
            and pe.event_date =
             (select max(event_date)
                from pat_pw_event_entry pe2
               where pe2.pw_event_module_id = t.pw_event_module_id)
            and rownum=1) as current_status

        ,(select es.event_severity
          from pat_pw_event_entry pe,
               stat_event_severity es
          where pe.event_severity_id = es.event_severity_id
            and pe.patient_id = t.patient_id
            and pe.pw_event_module_id = t.pw_event_module_id
            and pe.event_date =
             (select max(event_date)
                from pat_pw_event_entry pe2
               where pe2.pw_event_module_id = t.pw_event_module_id)
            and rownum=1) as current_severity

          ,scores.description
          ,scores.interpretation
          ,scores.current_score
          ,scores.previous_score
          ,scores.exists_previous_score

          from PAT_PW_EVENT_MODULE t,
               intake_module t2,
               (select
                 t.patient_id
                ,t.mid
                ,t.intake_id
                ,t.series
                ,t.description
                ,t.interpretation
                ,t.score as current_score
                ,nvl((select 1
                  from data_intake_score s
                  where s.patient_id=t.patient_id
                    and s.mid = t.mid
                    and s.intake_id=(select max(s.intake_id)
                                     from data_intake_score s
                                     where s.patient_id = t.patient_id
                                       and s.mid = t.mid
                                       and s.intake_id < t.intake_id
                                       and s.series = t.series)
                    and s.series=t.series),0) as exists_previous_score
                ,(select s.score
                  from data_intake_score s
                  where s.patient_id=t.patient_id
                    and s.mid = t.mid
                    and s.intake_id=(select max(s.intake_id)
                                     from data_intake_score s
                                     where s.patient_id = t.patient_id
                                       and s.mid = t.mid
                                       and s.intake_id < t.intake_id
                                       and s.series = t.series)
                    and s.series=t.series) as previous_score
                from data_intake_score t
                where t.patient_id = pi_vPatientID
                  and lower(t.description) in('total score', 'total score raw', 'total score standard', 'rate')) scores
          where t.patient_id = pi_vPatientID
            and t.pat_pw_event_id = pi_nPatPWEventID
            and t2.mid = t.mid
            and nvl(t.intake_id,-1) > 0
            and t.pw_event_module_id in(select distinct pw_event_module_id
                                        from PAT_PW_EVENT_ENTRY
                                        where patient_id = pi_vPatientID
                                          and pat_pw_event_id = pi_nPatPWEventID)
            and scores.patient_id(+) = t.patient_id
            and scores.mid(+)        = t.mid
            and scores.intake_id(+)  = t.intake_id
       order by t.mid, t.date_scheduled, scores.series
       )
    loop
      -- Format string
      if v_nBreakMID = rec.mid and v_nBreakIntakeID = rec.intake_id then
        --add current score
        if rec.description is not null then
          v_vCurrentScore := v_vCurrentScore || 'Current ' || rec.description || ': ';
          if rec.current_score is null then
            v_vCurrentScore := v_vCurrentScore || '__ ' || rec.interpretation || chr(10);
          else
            v_vCurrentScore := v_vCurrentScore || rec.current_score || ' ' ||rec.interpretation || chr(10);
          end if;
        end if;
        --add previous score
        if rec.description is not null then
          if rec.exists_previous_score = 1 then
            v_vPreviousScore := v_vPreviousScore || 'Previous ' || rec.description || ': ';
            if rec.previous_score is null then
              v_vPreviousScore := v_vPreviousScore || '__ ' || rec.interpretation || chr(10);
            else
              v_vPreviousScore := v_vPreviousScore || rec.previous_score || ' ' || rec.interpretation || chr(10);
            end if;
          end if;
        end if;
      else
        -- check if we need to break...
        if v_nBreakMID != -1 or v_nBreakIntakeID != -1 then
          v_vResponse := v_vResponse || v_vName || v_vCurrentScore || v_vPreviousScore || v_vStatus;
          v_vResponse := v_vResponse || chr(10) || chr(10);

          --reset var
          v_vName := '';
          v_vCurrentScore := '';
          v_vPreviousScore := '';
          v_vStatus := '';

        end if;

        -- hold key to identify when to break
        v_nBreakMID := rec.mid;
        v_nBreakIntakeID := rec.intake_id;

        --set module name
        if rec.acronym is null then
          v_vName := rec.module || chr(10);
        else
          v_vName := rec.acronym || ' ' || rec.module || chr(10);
        end if;
        --set current score
        if rec.description is not null then
          v_vCurrentScore := 'Current ' || rec.description || ': ';
          if rec.current_score is null then
            v_vCurrentScore := v_vCurrentScore || '__ ' || rec.interpretation || chr(10);
          else
            v_vCurrentScore := v_vCurrentScore || rec.current_score || ' ' ||rec.interpretation || chr(10);
          end if;
        end if;
        --set previous score
        if rec.description is not null then
          if rec.exists_previous_score = 1 then
            v_vPreviousScore := 'Previous ' || rec.description || ': ';
            if rec.previous_score is null then
              v_vPreviousScore := v_vPreviousScore || '__ ' || rec.interpretation || chr(10);
            else
              v_vPreviousScore := v_vPreviousScore || rec.previous_score || ' ' || rec.interpretation || chr(10);
            end if;
          end if;
        end if;
        --set status
        v_vStatus := 'Status: ';
        if rec.current_status is null then
          v_vStatus := v_vStatus || '____';
        else
          v_vStatus := v_vStatus || rec.current_status;
        end if;
      end if;
    end loop;

    -- add the last one...
    v_vResponse := v_vResponse || v_vName || v_vCurrentScore || v_vPreviousScore || v_vStatus;


    if v_vResponse is null then
      v_vResponse := '______________';
    else
      v_vResponse := v_vResponse || chr(10) || chr(10);
    end if;

    po_vResponseValue := v_vResponse;
    return po_vResponseValue;

  exception
    when others then
      return po_vResponseValue;
  end;

  /*Get outcomes reviewed*/
  function fnGetOutcomesReviewedList2(pi_vPatientID        in varchar2,
                                      pi_nPatPWEventID     in number) return clob
  is

    v_nBreakMID       number := -1;
    v_nBreakIntakeID  number := -1;

    v_vName           varchar2(32767) := '';
    v_vCurrentScore   varchar2(32767) := '';
    v_vPreviousScore  varchar2(32767) := '';
    v_vStatus         varchar2(32767) := '';

    --v_vResponse       varchar2(32767) := '';
    --po_vResponseValue varchar2(32767) := '';

    v_vResponse       clob := '';
    po_vResponseValue clob := '';

  begin

    --get all outcomes that are reviewed
    for rec in (
        select
       --t.patient_id,
       --t.pat_pw_id,
       --t.pat_pw_event_id,
       --t.pw_event_module_id,
         t.mid
        ,t.intake_id
        ,t2.acronym
        ,t2.module
        ,(select es.event_status
          from pat_pw_event_entry pe,
               stat_event_status es
          where pe.event_status_id = es.event_status_id
            and pe.patient_id = t.patient_id
            and pe.pw_event_module_id = t.pw_event_module_id
            and pe.event_date =
             (select max(event_date)
                from pat_pw_event_entry pe2
               where pe2.pw_event_module_id = t.pw_event_module_id)
            and rownum=1) as current_status

        ,(select es.event_severity
          from pat_pw_event_entry pe,
               stat_event_severity es
          where pe.event_severity_id = es.event_severity_id
            and pe.patient_id = t.patient_id
            and pe.pw_event_module_id = t.pw_event_module_id
            and pe.event_date =
             (select max(event_date)
                from pat_pw_event_entry pe2
               where pe2.pw_event_module_id = t.pw_event_module_id)
            and rownum=1) as current_severity

          ,scores.description
          ,scores.interpretation
          ,scores.current_score
          ,scores.previous_score
          ,scores.exists_previous_score

          from PAT_PW_EVENT_MODULE t,
               intake_module t2,
               (select
                 t.patient_id
                ,t.mid
                ,t.intake_id
                ,t.series
                ,t.description
                ,t.interpretation
                ,t.score as current_score
                ,nvl((select 1
                  from data_intake_score s
                  where s.patient_id=t.patient_id
                    and s.mid = t.mid
                    and s.intake_id=(select max(s.intake_id)
                                     from data_intake_score s
                                     where s.patient_id = t.patient_id
                                       and s.mid = t.mid
                                       and s.intake_id < t.intake_id
                                       and s.series = t.series)
                    and s.series=t.series),0) as exists_previous_score
                ,(select s.score
                  from data_intake_score s
                  where s.patient_id=t.patient_id
                    and s.mid = t.mid
                    and s.intake_id=(select max(s.intake_id)
                                     from data_intake_score s
                                     where s.patient_id = t.patient_id
                                       and s.mid = t.mid
                                       and s.intake_id < t.intake_id
                                       and s.series = t.series)
                    and s.series=t.series) as previous_score
                from data_intake_score t
                where t.patient_id = pi_vPatientID
                  --and (
                  --  lower(t.description) in('total score', 'total score raw', 'total score standard', 'rate') or
                  --  lower(t.description) like '%subscale%'
                  --  )
                 ) scores
          where t.patient_id = pi_vPatientID
            and t.pat_pw_event_id = pi_nPatPWEventID
            and t2.mid = t.mid
            and nvl(t.intake_id,-1) > 0
            and t.pw_event_module_id in(select distinct pw_event_module_id
                                        from PAT_PW_EVENT_ENTRY
                                        where patient_id = pi_vPatientID
                                          and pat_pw_event_id = pi_nPatPWEventID)
            and scores.patient_id(+) = t.patient_id
            and scores.mid(+)        = t.mid
            and scores.intake_id(+)  = t.intake_id
       order by t.mid, t.date_scheduled, scores.series
       )
    loop
      -- Format string
      if v_nBreakMID = rec.mid and v_nBreakIntakeID = rec.intake_id then
        --add current score
        if rec.description is not null then
          v_vCurrentScore := v_vCurrentScore || 'Current ' || rec.description || ': ';
          if rec.current_score is null then
            v_vCurrentScore := v_vCurrentScore || '__ ' || rec.interpretation || chr(10);
          else
            v_vCurrentScore := v_vCurrentScore || rec.current_score || ' ' ||rec.interpretation || chr(10);
          end if;
        end if;
        --add previous score
        if rec.description is not null then
          if rec.exists_previous_score = 1 then
            v_vPreviousScore := v_vPreviousScore || 'Previous ' || rec.description || ': ';
            if rec.previous_score is null then
              v_vPreviousScore := v_vPreviousScore || '__ ' || rec.interpretation || chr(10);
            else
              v_vPreviousScore := v_vPreviousScore || rec.previous_score || ' ' || rec.interpretation || chr(10);
            end if;
          end if;
        end if;
      else
        -- check if we need to break...
        if v_nBreakMID != -1 or v_nBreakIntakeID != -1 then
          v_vResponse := v_vResponse || v_vName || v_vCurrentScore || v_vPreviousScore || v_vStatus;
          v_vResponse := v_vResponse || chr(10) || chr(10);

          --reset var
          v_vName := '';
          v_vCurrentScore := '';
          v_vPreviousScore := '';
          v_vStatus := '';

        end if;

        -- hold key to identify when to break
        v_nBreakMID := rec.mid;
        v_nBreakIntakeID := rec.intake_id;

        --set module name
        if rec.acronym is null then
          v_vName := rec.module || chr(10);
        else
          v_vName := rec.acronym || ' ' || rec.module || chr(10);
        end if;
        --set current score
        if rec.description is not null then
          v_vCurrentScore := 'Current ' || rec.description || ': ';
          if rec.current_score is null then
            v_vCurrentScore := v_vCurrentScore || '__ ' || rec.interpretation || chr(10);
          else
            v_vCurrentScore := v_vCurrentScore || rec.current_score || ' ' ||rec.interpretation || chr(10);
          end if;
        end if;
        --set previous score
        if rec.description is not null then
          if rec.exists_previous_score = 1 then
            v_vPreviousScore := 'Previous ' || rec.description || ': ';
            if rec.previous_score is null then
              v_vPreviousScore := v_vPreviousScore || '__ ' || rec.interpretation || chr(10);
            else
              v_vPreviousScore := v_vPreviousScore || rec.previous_score || ' ' || rec.interpretation || chr(10);
            end if;
          end if;
        end if;
        --set status
        v_vStatus := 'Status: ';
        if rec.current_status is null then
          v_vStatus := v_vStatus || '____';
        else
          v_vStatus := v_vStatus || rec.current_status;
        end if;
      end if;
    end loop;

    -- add the last one...
    v_vResponse := v_vResponse || v_vName || v_vCurrentScore || v_vPreviousScore || v_vStatus;


    if v_vResponse is null then
      v_vResponse := '______________';
    else
      v_vResponse := v_vResponse || chr(10) || chr(10);
    end if;

    po_vResponseValue := v_vResponse;
    return po_vResponseValue;

  exception
    when others then
      return po_vResponseValue;
  end;

  /*Get outcome notes*/
  function fnGetOutcomesNotes(pi_vPatientID              in varchar2,
                              pi_nPatPWEventID           in number) return varchar2 
  is

    v_vResponse       varchar2(32767) := '';
    po_vResponseValue varchar2(32767) := '';

  begin

    --get all outcomes notes
    for rec in (
        select
         TO_CHAR(e.event_date, 'YYYY-DD-MM HH24:MI:SS') || chr(10) || u.name || chr(10) || e.event_comment as note
        from pat_pw_event_entry e,
             app_user u
        where e.fx_user_id = u.fx_user_id
          and e.patient_id = pi_vPatientID
          and e.pat_pw_event_id = pi_nPatPWEventID
        order by e.event_date
       )
    loop
      if rec.note is not null then
          v_vResponse := v_vResponse || chr(10) || rec.note || chr(10);
      end if;
    end loop;

    if v_vResponse is null then
      v_vResponse := '______________';
    else
      v_vResponse := v_vResponse;
    end if;

    po_vResponseValue := v_vResponse;
    return po_vResponseValue;

  exception
    when others then
      return po_vResponseValue;
  end;

  /*Get question response list*/
  function fnGetQuestionResponseList(pi_vPatientID        in varchar2,
                                     pi_nModuleIdentifier in varchar2,
                                     pi_nTID              in number,
                                     pi_nQID              in number) return varchar2 
  is

    v_nIntakeID       number := -1;
    v_vResponse       varchar2(32767) := '';
    po_vResponseValue varchar2(32767) := '';

    rs RetRefCursor;
  begin

    --get the last intake id for the module specified
    begin
      select max(i.intake_id)
        into v_nIntakeID
      from data_intake i,
           intake_module m
      where i.mid = m.mid
        and i.patient_id = pi_vPatientID
        and m.identifier = pi_nModuleIdentifier;
      exception
        when others then
          v_nIntakeID := -1;
    end;

    --get all responses for the question
    for rec in (select
                  trim(
                  case
                    when r.display_type = 3 then
                      r.response || ' ' ||
                      rs.response_value ||
                      nvl(' ' || r.unit, '')
                    when r.display_type in(4,22) then
                      r.response || ' ' ||
                      rs.response_value
                    else
                      rs.response_value
                  end) as response_value
                from data_intake_responses rs,
                     intake_module m,
                     intake_response r
                where m.mid = rs.mid
                  and r.mid = rs.mid
                  and r.rid = rs.rid
                  and rs.patient_id = pi_vPatientID
                  and m.identifier = pi_nModuleIdentifier
                  and rs.tid = pi_nTID
                  and rs.qid = pi_nQID
                  and rs.intake_id = v_nIntakeID)
    loop
      if rec.response_value is not null then
        v_vResponse := v_vResponse || chr(9) || rec.response_value || chr(10);
      end if;
    end loop;

    if v_vResponse is null then
      v_vResponse := '______________';
    end if;

    po_vResponseValue := v_vResponse;
    return po_vResponseValue;

  exception
    when others then
      return po_vResponseValue;
  end;

  /*Get module responses*/
  function fnGetModuleResponses(pi_vPatientID        in varchar2,
                                pi_nModuleIdentifier in varchar2) return clob
  is
    v_nIntakeID       number := -1;
    v_nTID            number := 0;
    v_nQID            number := 0;
    v_vResponse       clob := '';
    po_vResponseValue clob := '';

    rs RetRefCursor;
  begin

    --get the last intake id for the module specified
    begin
      select max(i.intake_id)
        into v_nIntakeID
      from data_intake i,
           intake_module m
      where i.mid = m.mid
        and i.patient_id = pi_vPatientID
        and m.identifier = pi_nModuleIdentifier;
      exception
        when others then
          v_nIntakeID := -1;
    end;

    --get all question & responses for the module
    for rec in (select
                  dr.tid,
                  dr.qid,
                  REGEXP_REPLACE(iq.question, '<[^<>]+>') as question,
                  trim(REGEXP_REPLACE(
                       case
                         when ir.display_type = 3 then ir.response || ' ' || dr.response_value || nvl(' ' || ir.unit, '')
                         when ir.display_type in(4,22) then ir.response || ' ' || dr.response_value
                         else dr.response_value
                       end
                       , '<[^<>]+>')
                  ) as response
                from data_intake_responses dr,
                     intake_module im,
                     intake_topic it,
                     intake_question iq,
                     intake_response ir
                where dr.patient_id = pi_vPatientID
                  and im.identifier = pi_nModuleIdentifier
                  and dr.intake_id = v_nIntakeID

                --intake_module
                    and   dr.mid = im.mid

                --intake_topic
                    and   dr.mid = it.mid
                    and   dr.tid = it.tid

                --intake_question
                    and   dr.mid = iq.mid
                    and   dr.tid = iq.tid
                    and   dr.qid = iq.qid

                --intake_response
                    and   dr.mid = ir.mid
                    and   dr.tid = ir.tid
                    and   dr.qid = ir.qid
                    and   dr.rid = ir.rid

                order by dr.mid,
                    dr.tid,
                    dr.qid,
                    dr.rid )
    loop
      if v_nTID = 0 and v_nQID = 0 then
        v_nTID := rec.tid;
        v_nQID := rec.qid;
        if rec.question is not null then
          v_vResponse := v_vResponse || rec.question || chr(10);
        end if;
      end if;

      if v_nTID != rec.tid or v_nQID != rec.qid then
        v_nTID := rec.tid;
        v_nQID := rec.qid;
        v_vResponse := v_vResponse || chr(10);
        if rec.question is not null then
          v_vResponse := v_vResponse || rec.question || chr(10);
        end if;
      end if;

      if rec.response is not null then
        v_vResponse := v_vResponse || rec.response || chr(10);
      end if;

    end loop;

    if v_vResponse is null then
      v_vResponse := '______________';
    end if;

    po_vResponseValue := v_vResponse;
    return po_vResponseValue;

  exception
    when others then
      return po_vResponseValue;
  end;

  /*Get module responses*/
  function fnGetModuleResponses(pi_vPatientID        in varchar2,
                                pi_nModuleIdentifier in varchar2,
                                pi_nIntakeID         in number) return clob
  is
    v_nTID            number := 0;
    v_nQID            number := 0;
    v_vResponse       clob := '';
    po_vResponseValue clob := '';

    rs RetRefCursor;
  begin

    --get all question & responses for the module
    for rec in (select
                  dr.tid,
                  dr.qid,
                  dr.intake_id,
                  dr.rid,
                  dr.mid,
                  REGEXP_REPLACE(
                    REGEXP_REPLACE(
                      replace(iq.question,chr(38) || 'nbsp;',''),
                      '<br\s{0,}/{0,}>',
                      chr(10)
                    ),
                    '<[^<>]+>'
                  ) as question,
                  trim(REGEXP_REPLACE(
                       case
                         when ir.display_type = 3 then ir.response || ' ' || dr.response_value || nvl(' ' || ir.unit, '')
                         when ir.display_type in(4,22) then ir.response || ' ' || dr.response_value
                         else dr.response_value
                       end
                       , '<[^<>]+>')
                  ) as response
                from data_intake_responses dr,
                     intake_module im,
                     intake_topic it,
                     intake_question iq,
                     intake_response ir
                where dr.patient_id = pi_vPatientID
                  and im.identifier = pi_nModuleIdentifier
                  and dr.intake_id = pi_nIntakeID

                --intake_module
                    and   dr.mid = im.mid

                --intake_topic
                    and   dr.mid = it.mid
                    and   dr.tid = it.tid

                --intake_question
                    and   dr.mid = iq.mid
                    and   dr.tid = iq.tid
                    and   dr.qid = iq.qid

                --intake_response
                    and   dr.mid = ir.mid
                    and   dr.tid = ir.tid
                    and   dr.qid = ir.qid
                    and   dr.rid = ir.rid

                order by dr.mid,
                    dr.tid,
                    dr.qid,
                    dr.rid )
    loop
      if v_nTID = 0 and v_nQID = 0 then
        v_nTID := rec.tid;
        v_nQID := rec.qid;
        if rec.question is not null then
          v_vResponse := v_vResponse || rec.question || chr(10);
        end if;
      end if;

      if v_nTID != rec.tid or v_nQID != rec.qid then
        v_nTID := rec.tid;
        v_nQID := rec.qid;
        v_vResponse := v_vResponse || chr(10);
        if rec.question is not null then
          v_vResponse := v_vResponse || rec.question || chr(10);
        end if;
      end if;

      if rec.response is not null then
        --Put time in one horizontal line
        if rec.mid = 4076 and rec.tid = 1 and rec.qid = 4 and rec.rid = 125 then
           v_vResponse := v_vResponse || rec.response;
        else   
           if rec.mid = 4076 and rec.tid = 1 and rec.qid = 4 and rec.rid = 130 then
              v_vResponse := v_vResponse || REGEXP_REPLACE(rec.response,' ','');
           else
              if rec.mid = 4076 and rec.tid = 1 and rec.qid = 3 and rec.rid = 110 then
                 v_vResponse := v_vResponse || rec.response;
              else   
                 if rec.mid = 4076 and rec.tid = 1 and rec.qid = 3 and rec.rid = 115 then
                    v_vResponse := v_vResponse || REGEXP_REPLACE(rec.response,' ','');
                 else 
                    v_vResponse := v_vResponse || rec.response || chr(10);
                 end if;
              end if;   
           end if;   
        end if;
      end if;

    end loop;

    if v_vResponse is null then
      v_vResponse := '______________';
    end if;

    po_vResponseValue := v_vResponse;
    return po_vResponseValue;

  exception
    when others then
      return po_vResponseValue;
  end;

  /*Get module score*/
  function fnGetModuleScore(pi_vPatientID  in varchar2,
                            pi_nMID        in number,
                            pi_nIntakeID   in number) return clob
  is

    v_nCtr            number := 0;
    v_vResponse       clob := '';
    po_vResponseValue clob := '';

    rs RetRefCursor;
  begin

    --get all scores for the module
    for rec in (select
                 t.series,
                 t.offSet1,
                 t.offSet2,
                 rpad(t.description,t.offSet1 + 2) || lpad(t.score,t.offSet2) || '  ' || t.interpretation as ScoreLine
                from (
                  select
                    series,
                    description,
                    score,
                    interpretation,
                    case
                      when (select max(length(off1.description)) from data_intake_score off1 where off1.patient_id = pi_vPatientID and off1.mid = pi_nMID and off1.intake_id = pi_nIntakeID) <= 11 then 11
                      else (select max(length(off1.description)) from data_intake_score off1 where off1.patient_id = pi_vPatientID and off1.mid = pi_nMID and off1.intake_id = pi_nIntakeID)
                    end as offSet1,
                    case
                      when (select max(length(off2.score)) from data_intake_score off2 where off2.patient_id = pi_vPatientID and off2.mid = pi_nMID and off2.intake_id = pi_nIntakeID) <= 5 then 5
                      else (select max(length(off2.score)) from data_intake_score off2 where off2.patient_id = pi_vPatientID and off2.mid = pi_nMID and off2.intake_id = pi_nIntakeID)
                    end as offSet2
                  from data_intake_score s
                  where patient_id = pi_vPatientID
                    and mid = pi_nMID
                    and intake_id = pi_nIntakeID
                ) t
                order by t.series
                )
    loop
      v_nCtr := v_nCtr + 1;

      if v_nCtr = 1 then
        v_vResponse := rpad('Description',rec.offset1 + 2) || lpad('Score',rec.offset2) || '  ' || 'Interpretation' || chr(10);
      end if;

/*      if rec.description is not null then
        v_vResponse := v_vResponse || rpad(rec.description, rec.offset1 + 2);
      end if;

      if rec.score is not null then
        v_vResponse := v_vResponse || lpad(rec.score, rec.offset2) || '  ';
      end if;

      if rec.interpretation is not null then
        v_vResponse := v_vResponse || rec.interpretation;
      end if;
  */
      v_vResponse := v_vResponse || rec.Scoreline;

      v_vResponse := v_vResponse || chr(10);

    end loop;

    if v_vResponse is null then
      v_vResponse := '______________';
    end if;

    po_vResponseValue := v_vResponse;
    return po_vResponseValue;

  exception
    when others then
      return po_vResponseValue;
  end;

  /*Get all completed modules*/
  function fnGetAllCompletedModules(pi_vPatientID  in varchar2,
                                    pi_nPatPWEventID in number) return clob
  is

    v_nCtr            number := 0;
    v_vResponse       clob := '';
    po_vResponseValue clob := '';

    rs RetRefCursor;

  begin

      for rec in (select
                   m.module as ModuleSection,
                   PCK_NOTE_PREFILL.fnGetModuleScore(em.patient_id, em.mid, em.intake_id) as ScoreSection,
                   PCK_NOTE_PREFILL.fnGetModuleResponses(em.patient_id, m.identifier,em.intake_id) as QASection
                  from pat_pw_event_module em,
                       intake_module m
                  where m.mid = em.mid
                    and em.patient_id = pi_vPatientID
                    and em.pat_pw_event_id = pi_nPatPWEventID
                    and em.status = 1
                    and case
                          when em.mid = 4042 then
                            case
                              when (select c.rid from data_intake_responses c where c.intake_id = em.intake_id and c.tid=1 and qid=1) != 21 then 1
                              else 0
                            end
                          else 1
                        end = 1)
      loop
        if rec.modulesection is not null then
          v_vResponse := v_vResponse || rec.modulesection || chr(10);
          v_vResponse := v_vResponse || '------------------------------------------------------------------------' || chr(10);
        end if;

        if rec.scoresection is not null and rec.scoresection != '______________' then
          v_vResponse := v_vResponse || rec.scoresection || chr(10);
        end if;

        if rec.qasection is not null and rec.qasection != '______________' then
          v_vResponse := v_vResponse || 'Questions & Responses' || chr(10);
          v_vResponse := v_vResponse || rec.qasection || chr(10) || chr(10);
        end if;

      end loop;

      if v_vResponse is null then
        v_vResponse := '______________';
      end if;

      po_vResponseValue := v_vResponse;
      return po_vResponseValue;

 exception
    when others then
      return po_vResponseValue;
  end;


end PCK_NOTE_PREFILL;
/

